#include "AnimTex.h"

/*
CAnimTex::CAnimTex()
{
}

CAnimTex::~CAnimTex()
{
}
*/

//Initialisation des paramtres
void CAnimTex::setParam(unsigned char nbPL,unsigned char nbPict,float speedAnim,float dimX,float dimY,unsigned char sId)//,float tsx,float tsy)
{
    this->nbPL=nbPL;
    this->nbPict=nbPict;
    this->speedAnim=speedAnim;
    this->dimX=dimX;
    this->dimY=dimY;
    //this->tsx=tsx;
    //this->tsy=tsy;
    imNm=sId;
    tx1=dimX*sId;//tsx;
    ty1=dimY*sId;//tsy;
    tx2=tx1+dimX;
    ty2=ty1+dimY;
}

//Animation
void CAnimTex::update(float elapsedTime)
{
    imNm+=speedAnim*elapsedTime;
    while(imNm>nbPict)imNm-=nbPict;
    
    unsigned char idX=(unsigned char)imNm,idY;
    idY=idX/nbPL;
    idX%=nbPL;
    
    tx1=idX*dimX;//+tsx
    ty1=idY*dimY;//+tsy
    tx2=tx1+dimX;
    ty2=ty1+dimY;
}



unsigned int CExplositonAnim::idTex=0xFFFFFFFF;

//px,py,pz = position
//dmg = dgat lorsque quelque chose passe dans l'explosion.
//life = dure de vie dans le temps
//sclMin = taille minimal au dbut et sclMax  la fin de la vie de l'explosion.
//nbPL... info sur la texture
CExplositonAnim::CExplositonAnim(float px,float py,float pz,float dmg,float life,float sclMin,float sclMax,unsigned char nbPL,unsigned char nbPict,float speedAnim,float dimX,float dimY,unsigned char sId)//,float tsx,float tsy)
:CExplosion(px,py,pz,sclMin,dmg,life)
{
    cAnmTex.setParam(nbPL,nbPict,speedAnim,dimX,dimY,sId);//,tsx,tsy);
    this->sclMax=sclMax;
    this->sclDelta=sclMin-sclMax;
    this->sLife=life;
}

CExplositonAnim::~CExplositonAnim()
{
}

//Mettre l'indice OpenGL de la texture qui doit tre utiliser pour l'explosion.
void CExplositonAnim::setIdTex(unsigned int idText)
{
    CExplositonAnim::idTex=idText;
}

bool CExplositonAnim::frameMove(float elapsedTime)
{
    life-=elapsedTime;
    if(life<=0.0)return true;
    
    float coef=life/sLife;
    rayon=sclMax+sclDelta*coef;
    
    cAnmTex.update(elapsedTime);
    
    return false;
}

#include <GL\gl.h>
#include <GL\glu.h>

GLfloat matBaseSpecExp[4]={0.6,0.6,0.6,1.0};
GLfloat matBaseDiffExp[4]={0.8,0.8,0.8,1.0};
GLfloat matBaseAmbExp[4]={0.1,0.1,0.1,1.0};
GLfloat matBaseEmiExp[4]={1.0,1.0,1.0,1.0};
GLfloat matBaseShinessExp=0.0;

void CExplositonAnim::render()
{
    glMaterialfv (GL_FRONT_AND_BACK,GL_AMBIENT,matBaseSpecExp);
    glMaterialfv (GL_FRONT_AND_BACK,GL_DIFFUSE,matBaseDiffExp);
    glMaterialfv (GL_FRONT_AND_BACK,GL_SPECULAR,matBaseAmbExp);
    glMaterialfv (GL_FRONT_AND_BACK,GL_EMISSION,matBaseEmiExp);
    glMaterialfv (GL_FRONT_AND_BACK,GL_SHININESS,&matBaseShinessExp);
    
    if(idTex!=0xFFFFFFFF)
    {
     glEnable(GL_TEXTURE_2D);
     glBindTexture( GL_TEXTURE_2D, idTex );
    }
    else glDisable(GL_TEXTURE_2D);
    
    //glEnable(GL_BLEND);
    //glDepthMask(GL_FALSE);
    //glBlendFunc(GL_SRC_ALPHA,GL_ONE);//LIGHT
    
    //glDisable(GL_CULL_FACE);
    
    glPushMatrix();
    glTranslatef(pos.x,pos.y,pos.z);
    
    glBegin(GL_QUADS);
    
    glNormal3f(0.0,0.0,-1.0);
    glTexCoord2f(cAnmTex.tx1,cAnmTex.ty1);
    glVertex3f(-rayon,-rayon,0.0);
    glTexCoord2f(cAnmTex.tx1,cAnmTex.ty2);
    glVertex3f(-rayon,rayon,0.0);
    glTexCoord2f(cAnmTex.tx2,cAnmTex.ty2);
    glVertex3f(rayon,rayon,0.0);
    glTexCoord2f(cAnmTex.tx2,cAnmTex.ty1);
    glVertex3f(rayon,-rayon,0.0);
    
    glNormal3f(0.0,0.0,1.0);
    glTexCoord2f(cAnmTex.tx2,cAnmTex.ty1);
    glVertex3f(rayon,-rayon,0.0);
    glTexCoord2f(cAnmTex.tx2,cAnmTex.ty2);
    glVertex3f(rayon,rayon,0.0);
    glTexCoord2f(cAnmTex.tx1,cAnmTex.ty2);
    glVertex3f(-rayon,rayon,0.0);
    glTexCoord2f(cAnmTex.tx1,cAnmTex.ty1);
    glVertex3f(-rayon,-rayon,0.0);
    
    glNormal3f(0.0,-1.0,0.0);
    glTexCoord2f(cAnmTex.tx1,cAnmTex.ty1);
    glVertex3f(-rayon,0.0,-rayon);
    glTexCoord2f(cAnmTex.tx1,cAnmTex.ty2);
    glVertex3f(-rayon,0.0,rayon);
    glTexCoord2f(cAnmTex.tx2,cAnmTex.ty2);
    glVertex3f(rayon,0.0,rayon);
    glTexCoord2f(cAnmTex.tx2,cAnmTex.ty1);
    glVertex3f(rayon,0.0,-rayon);
    
    glNormal3f(0.0,1.0,0.0);
    glTexCoord2f(cAnmTex.tx2,cAnmTex.ty1);
    glVertex3f(rayon,0.0,-rayon);
    glTexCoord2f(cAnmTex.tx2,cAnmTex.ty2);
    glVertex3f(rayon,0.0,rayon);
    glTexCoord2f(cAnmTex.tx1,cAnmTex.ty2);
    glVertex3f(-rayon,0.0,rayon);
    glTexCoord2f(cAnmTex.tx1,cAnmTex.ty1);
    glVertex3f(-rayon,0.0,-rayon);
    
    glNormal3f(-1.0,0.0,0.0);
    glTexCoord2f(cAnmTex.tx1,cAnmTex.ty1);
    glVertex3f(0.0,-rayon,-rayon);
    glTexCoord2f(cAnmTex.tx1,cAnmTex.ty2);
    glVertex3f(0.0,-rayon,rayon);
    glTexCoord2f(cAnmTex.tx2,cAnmTex.ty2);
    glVertex3f(0.0,rayon,rayon);
    glTexCoord2f(cAnmTex.tx2,cAnmTex.ty1);
    glVertex3f(0.0,rayon,-rayon);
    
    glNormal3f(1.0,0.0,0.0);
    glTexCoord2f(cAnmTex.tx2,cAnmTex.ty1);
    glVertex3f(0.0,rayon,-rayon);
    glTexCoord2f(cAnmTex.tx2,cAnmTex.ty2);
    glVertex3f(0.0,rayon,rayon);
    glTexCoord2f(cAnmTex.tx1,cAnmTex.ty2);
    glVertex3f(0.0,-rayon,rayon);
    glTexCoord2f(cAnmTex.tx1,cAnmTex.ty1);
    glVertex3f(0.0,-rayon,-rayon);
    
    glEnd();
    
    glPopMatrix();
    
    //glDepthMask(GL_TRUE);
    //glDisable(GL_BLEND);
}
